<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Home::index');

// Rutas de API
$routes->group('api', function($routes) {
    
    // ========== AUTH (Sin protección) ==========
    $routes->post('login', 'AuthController::login');
    $routes->post('register', 'AuthController::register');

    // ========== PERFIL (Protegido) ✅ CORREGIDO ==========
    $routes->get('perfil', 'AuthController::perfil');                    // ✅ CORREGIDO
    $routes->put('perfil', 'AuthController::actualizarPerfil');          // ✅ CORREGIDO
    $routes->put('cambiar-password', 'AuthController::cambiarPassword');
    $routes->delete('cuenta', 'AuthController::eliminarCuenta');
    
    // ========== ESTUDIANTES (Protegido) ==========
    $routes->get('estudiantes', 'EstudiantesController::index');
    $routes->get('estudiantes/(:num)', 'EstudiantesController::show/$1');
    $routes->post('estudiantes', 'EstudiantesController::create');
    $routes->put('estudiantes/(:num)', 'EstudiantesController::update/$1');
    $routes->delete('estudiantes/(:num)', 'EstudiantesController::delete/$1');
    
    // ========== ASISTENCIAS (Protegido) ==========
    // ⚠️ RUTAS ESPECÍFICAS PRIMERO
    $routes->get('asistencias/estadisticas', 'AsistenciasController::estadisticas');
    $routes->get('asistencias/fecha/(:segment)', 'AsistenciasController::porFecha/$1');
    $routes->get('asistencias/historial/(:num)', 'AsistenciasController::historialEstudiante/$1');
    
    // Rutas CRUD genéricas
    $routes->get('asistencias', 'AsistenciasController::index');
    $routes->get('asistencias/(:num)', 'AsistenciasController::show/$1');
    $routes->post('asistencias', 'AsistenciasController::create');
    $routes->put('asistencias/(:num)', 'AsistenciasController::update/$1');
    $routes->delete('asistencias/(:num)', 'AsistenciasController::delete/$1');

    // ========== MATERIAS (Protegido) ==========
    // ⚠️ RUTAS CON /estudiantes PRIMERO
    $routes->get('materias/(:num)/estudiantes', 'MateriasController::getEstudiantes/$1');
    $routes->post('materias/(:num)/estudiantes', 'MateriasController::asignarEstudiante/$1');
    $routes->delete('materias/(:num)/estudiantes/(:num)', 'MateriasController::desasignarEstudiante/$1/$2');
    
    // Rutas CRUD de materias
    $routes->get('materias', 'MateriasController::index');
    $routes->get('materias/(:num)', 'MateriasController::show/$1');
    $routes->post('materias', 'MateriasController::create');
    $routes->put('materias/(:num)', 'MateriasController::update/$1');
    $routes->delete('materias/(:num)', 'MateriasController::delete/$1');
});
